/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/

#line 1 "rushopt.opt"
/* This file is part of Rush.                  
   Copyright (C) 2008, 2009 Sergey Poznyakoff

   Rush is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   Rush is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Rush.  If not, see <http://www.gnu.org/licenses/>. */

#line 17 "rushopt.opt"

#line 17
void print_help(void);
#line 17
void print_usage(void);
#line 72 "rushopt.opt"

#line 72
/* Option codes */
#line 72
enum {
#line 72
	_OPTION_INIT=255,
#line 72
	#line 30 "rushopt.opt"

#line 30
	OPTION_LINT,
#line 61 "rushopt.opt"

#line 61
	OPTION_SHOW_DEFAULT,
#line 72 "rushopt.opt"

#line 72
	OPTION_USAGE,
#line 72 "rushopt.opt"

#line 72
	OPTION_VERSION,

#line 72 "rushopt.opt"
	MAX_OPTION
#line 72
};
#line 72
static struct option long_options[] = {
#line 72
	#line 21 "rushopt.opt"

#line 21
	{ "debug", required_argument, 0, 'd' },
#line 28 "rushopt.opt"

#line 28
	{ "test", no_argument, 0, 't' },
#line 30 "rushopt.opt"

#line 30
	{ "lint", no_argument, 0, OPTION_LINT },
#line 35 "rushopt.opt"

#line 35
	{ "user", required_argument, 0, 'u' },
#line 53 "rushopt.opt"

#line 53
	{ "security-check", required_argument, 0, 'C' },
#line 61 "rushopt.opt"

#line 61
	{ "show-default", no_argument, 0, OPTION_SHOW_DEFAULT },
#line 72 "rushopt.opt"

#line 72
	{ "help", no_argument, 0, 'h' },
#line 72 "rushopt.opt"

#line 72
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 72 "rushopt.opt"

#line 72
	{ "version", no_argument, 0, OPTION_VERSION },

#line 72 "rushopt.opt"
	{0, 0, 0, 0}
#line 72
};
#line 72
static struct opthelp {
#line 72
        const char *opt;
#line 72
        const char *arg;
#line 72
        int is_optional;
#line 72
        const char *descr;
#line 72
} opthelp[] = {
#line 72
	#line 23 "rushopt.opt"

#line 23
	{ "-d, --debug", N_("NUMBER"), 0, N_("Set debugging level.") },
#line 31 "rushopt.opt"

#line 31
	{ "-t, --test, --lint", NULL, 0, N_("Run in test mode.") },
#line 37 "rushopt.opt"

#line 37
	{ "-u, --user", N_("NAME"), 0, N_("Supply user name in test mode.") },
#line 49 "rushopt.opt"

#line 49
	{ "-c", N_("COMMAND"), 0, N_("Execute COMMAND.") },
#line 55 "rushopt.opt"

#line 55
	{ "-C, --security-check", N_("CHECK"), 0, N_("Add or remove configuration security check.") },
#line 63 "rushopt.opt"

#line 63
	{ "--show-default", NULL, 0, N_("Show default configuration.") },
#line 72 "rushopt.opt"

#line 72
	{ NULL, NULL, 0, N_("Other options") },
#line 72 "rushopt.opt"

#line 72
	{ "-h, --help", NULL, 0, N_("Give this help list") },
#line 72 "rushopt.opt"

#line 72
	{ "--usage", NULL, 0, N_("Give a short usage message") },
#line 72 "rushopt.opt"

#line 72
	{ "--version", NULL, 0, N_("Print program version") },

#line 72 "rushopt.opt"
};
#line 17 "rushopt.opt"

#line 17
const char *program_version = "rush" " (" PACKAGE_STRING ")";
#line 17
static char doc[] = N_("rush - a restricted user shell.");
#line 17
static char args_doc[] = N_("[FILE]");
#line 17
const char *program_bug_address = "<" PACKAGE_BUGREPORT ">";
#line 17
		    
#line 17
#define DESCRCOLUMN 30
#line 17
#define RMARGIN 79
#line 17
#define GROUPCOLUMN 2
#line 17
#define USAGECOLUMN 13
#line 17
		    
#line 17
static void
#line 17
indent (size_t start, size_t col)
#line 17
{
#line 17
  for (; start < col; start++)
#line 17
    putchar (' ');
#line 17
}
#line 17
		    
#line 17
static void
#line 17
print_option_descr (const char *descr, size_t lmargin, size_t rmargin)
#line 17
{
#line 17
  while (*descr)
#line 17
    {
#line 17
      size_t s = 0;
#line 17
      size_t i;
#line 17
      size_t width = rmargin - lmargin;
#line 17

#line 17
      for (i = 0; ; i++)
#line 17
	{
#line 17
	  if (descr[i] == 0 || isspace (descr[i]))
#line 17
	    {
#line 17
	      if (i > width)
#line 17
		break;
#line 17
	      s = i;
#line 17
	      if (descr[i] == 0)
#line 17
		break;
#line 17
	    }
#line 17
	}
#line 17
      printf ("%*.*s\n", s, s, descr);
#line 17
      descr += s;
#line 17
      if (*descr)
#line 17
	{
#line 17
	  indent (0, lmargin);
#line 17
	  descr++;
#line 17
	}
#line 17
    }
#line 17
}
#line 17

#line 17
void
#line 17
print_help(void)
#line 17
{
#line 17
  unsigned i;
#line 17
  
#line 17
  printf ("%s %s [%s]... %s\n", _("Usage:"), "rush", _("OPTION"),
#line 17
	  gettext (args_doc)); 
#line 17
  if (doc && doc[0])
#line 17
    print_option_descr(gettext (doc), 0, RMARGIN);
#line 17
  putchar ('\n');
#line 17

#line 17
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 17
    {
#line 17
      unsigned n;
#line 17
      if (opthelp[i].opt)
#line 17
	{
#line 17
	  n = printf ("  %s", opthelp[i].opt);
#line 17
	  if (opthelp[i].arg)
#line 17
	    {
#line 17
	      char *cb, *ce;
#line 17
	      if (strlen (opthelp[i].opt) == 2)
#line 17
		{
#line 17
		  if (!opthelp[i].is_optional)
#line 17
		    {
#line 17
		      putchar (' ');
#line 17
		      n++;
#line 17
		    }
#line 17
		}
#line 17
	      else
#line 17
		{
#line 17
		  putchar ('=');
#line 17
		  n++;
#line 17
		}
#line 17
	      if (opthelp[i].is_optional)
#line 17
		{
#line 17
		  cb = "[";
#line 17
		  ce = "]";
#line 17
		}
#line 17
	      else
#line 17
		cb = ce = "";
#line 17
	      n += printf ("%s%s%s", cb, gettext (opthelp[i].arg), ce);
#line 17
	    }
#line 17
	  if (n >= DESCRCOLUMN)
#line 17
	    {
#line 17
	      putchar ('\n');
#line 17
	      n = 0;
#line 17
	    }
#line 17
	  indent (n, DESCRCOLUMN);
#line 17
	  print_option_descr (gettext (opthelp[i].descr), DESCRCOLUMN, RMARGIN);
#line 17
	}
#line 17
      else
#line 17
	{
#line 17
	  if (i)
#line 17
	    putchar ('\n');
#line 17
	  indent (0, GROUPCOLUMN);
#line 17
	  print_option_descr (gettext (opthelp[i].descr),
#line 17
			      GROUPCOLUMN, RMARGIN);
#line 17
	  putchar ('\n');
#line 17
	}
#line 17
    }
#line 17
  
#line 17
  putchar ('\n');
#line 17
  print_option_descr (_("Mandatory or optional arguments to long options are also mandatory or optional for any corresponding short options."), 0, RMARGIN);
#line 17
  putchar ('\n');
#line 17
  printf (_("Report bugs to %s.\n"), program_bug_address);
#line 17
}
#line 17

#line 17
void
#line 17
print_usage(void)
#line 17
{
#line 17
  unsigned i;
#line 17
  int f = 0;
#line 17
  unsigned n;
#line 17
  char buf[RMARGIN+1];
#line 17

#line 17
#define FLUSH                        do                                   {                              	  buf[n] = 0;              	  printf ("%s\n", buf);    	  n = USAGECOLUMN;         	  memset (buf, ' ', n);        }                                while (0)
#line 17
#define ADDC(c)   do { if (n == RMARGIN) FLUSH; buf[n++] = c; } while (0)
#line 17

#line 17
  n = snprintf (buf, sizeof buf, "%s %s ", _("Usage:"), "rush");
#line 17

#line 17
  /* Print a list of short options without arguments. */
#line 17
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 17
    {
#line 17
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 17
	  && opthelp[i].arg == NULL)
#line 17
	{
#line 17
	  if (f == 0)
#line 17
	    {
#line 17
	      ADDC('[');
#line 17
	      ADDC('-');
#line 17
	      f = 1;
#line 17
	    }
#line 17
	  ADDC(opthelp[i].opt[1]);
#line 17
	}
#line 17
    }
#line 17
  if (f)
#line 17
    ADDC(']');
#line 17

#line 17
  /* Print a list of short options with arguments. */
#line 17
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 17
    {
#line 17
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 17
	  && opthelp[i].arg)
#line 17
	{
#line 17
	  size_t len = 5 
#line 17
	                + strlen (opthelp[i].arg)
#line 17
			   + (opthelp[i].is_optional ? 2 : 1);
#line 17
	  if (n + len > RMARGIN) FLUSH;
#line 17
	  buf[n++] = ' '; 
#line 17
	  buf[n++] = '['; 
#line 17
	  buf[n++] = '-';
#line 17
	  buf[n++] = opthelp[i].opt[1];
#line 17
	  if (opthelp[i].is_optional)
#line 17
	    {
#line 17
	      buf[n++] = '[';
#line 17
	      strcpy (&buf[n], opthelp[i].arg);
#line 17
	      n += strlen (opthelp[i].arg);
#line 17
	      buf[n++] = ']';
#line 17
	    }
#line 17
	  else
#line 17
	    {
#line 17
	      buf[n++] = ' ';
#line 17
	      strcpy (&buf[n], opthelp[i].arg);
#line 17
	      n += strlen (opthelp[i].arg);
#line 17
	    }
#line 17
	  buf[n++] = ']';
#line 17
	}
#line 17
    }
#line 17

#line 17
  /* Print a list of long options */
#line 17
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 17
    {
#line 17
      if (opthelp[i].opt && opthelp[i].descr)
#line 17
	{
#line 17
	  size_t len;
#line 17
	  const char *longopt;
#line 17

#line 17
	  if (opthelp[i].opt[1] == '-')
#line 17
	    longopt = opthelp[i].opt;
#line 17
	  else if (opthelp[i].opt[2] == ',')
#line 17
	    longopt = opthelp[i].opt + 4;
#line 17
	  else
#line 17
	    continue;
#line 17

#line 17
	  len = 3 + strlen (longopt)
#line 17
	          + (opthelp[i].arg ? 1 + strlen (opthelp[i].arg)
#line 17
		      + (opthelp[i].is_optional ? 2 : 0) : 0);
#line 17
	  if (n + len > RMARGIN) FLUSH;
#line 17
	  buf[n++] = ' '; 
#line 17
	  buf[n++] = '['; 
#line 17
	  strcpy (&buf[n], longopt);
#line 17
	  n += strlen (longopt);
#line 17
	  if (opthelp[i].arg)
#line 17
	    {
#line 17
	      buf[n++] = '=';
#line 17
	      if (opthelp[i].is_optional)
#line 17
		{
#line 17
		  buf[n++] = '[';
#line 17
		  strcpy (&buf[n], opthelp[i].arg);
#line 17
		  n += strlen (opthelp[i].arg);
#line 17
		  buf[n++] = ']';
#line 17
		}
#line 17
	      else
#line 17
		{
#line 17
		  strcpy (&buf[n], opthelp[i].arg);
#line 17
		  n += strlen (opthelp[i].arg);
#line 17
		}
#line 17
	    }
#line 17
	  buf[n++] = ']';
#line 17
	}
#line 17
    }
#line 17
  FLUSH;
#line 17
  
#line 17
}
#line 17

#line 17
const char version_etc_copyright[] =
#line 17
  /* Do *not* mark this string for translation.  %s is a copyright
     symbol suitable for this locale, and %d is the copyright
     year.  */
#line 17
  "Copyright %s 2005, 2006, 2007, 2008 Sergey Poznyakoff";
#line 17

#line 17
void
#line 17
print_version_only(const char *program_version, FILE *stream)
#line 17
{
#line 17
	fprintf (stream, "%s\n", program_version);
#line 17
	/* TRANSLATORS: Translate "(C)" to the copyright symbol
	   (C-in-a-circle), if this symbol is available in the user's
	   locale.  Otherwise, do not translate "(C)"; leave it as-is.  */
#line 17
	fprintf (stream, version_etc_copyright, _("(C)"));
#line 17
	fputc ('\n', stream);
#line 17
}
#line 17

#line 17
void
#line 17
print_version(const char *program_version, FILE *stream)
#line 17
{
#line 17
	print_version_only(program_version, stream);
#line 17
	
#line 17
	fputs (_("License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.\n\n"),
#line 17
	       stream);
#line 17
	
#line 17
}
#line 17

#line 72 "rushopt.opt"

#line 72


void
get_options(int argc, char *argv[])
{
    
#line 77
 {
#line 77
  int c;
#line 77

#line 77

#line 77
  while ((c = getopt_long(argc, argv, "d:tu:c:C:h",
#line 77
                          long_options, NULL)) != EOF)
#line 77
    {
#line 77
      switch (c)
#line 77
        {
#line 77
        default:
#line 77
	exit(1);
#line 77
       
#line 77
	#line 23 "rushopt.opt"
	 case 'd':
#line 23
          {
#line 23

	debug_level = atoi(optarg);
	debug_option = 1;

#line 26
             break;
#line 26
          }
#line 31 "rushopt.opt"
	 case 't': case OPTION_LINT:
#line 31
          {
#line 31

	lint_option = 1;

#line 33
             break;
#line 33
          }
#line 37 "rushopt.opt"
	 case 'u':
#line 37
          {
#line 37

	lint_option = 1;
	if (getuid())
		die(usage_error,
		    NULL,
		    _("the --user option is allowed "
		      "for the superuser only"));
	test_user_name = optarg;

#line 45
             break;
#line 45
          }
#line 49 "rushopt.opt"
	 case 'c':
#line 49
          {
#line 49

	command = optarg;

#line 51
             break;
#line 51
          }
#line 55 "rushopt.opt"
	 case 'C':
#line 55
          {
#line 55

	if (cfck_keyword(optarg, strlen(optarg)))
		die(usage_error, NULL,
		    _("unknown keyword: %s"), optarg);

#line 59
             break;
#line 59
          }
#line 63 "rushopt.opt"
	 case OPTION_SHOW_DEFAULT:
#line 63
          {
#line 63

#ifdef RUSH_DEFAULT_CONFIG
	printf("%s\n", RUSH_DEFAULT_CONFIG);
	exit(0);
#else
	error(1, 0, _("No default configuration"));	
#endif

#line 70
             break;
#line 70
          }
#line 72 "rushopt.opt"
	 case 'h':
#line 72
          {
#line 72

#line 72
		print_help ();
#line 72
                exit (0);
#line 72
	 
#line 72
             break;
#line 72
          }
#line 72 "rushopt.opt"
	 case OPTION_USAGE:
#line 72
          {
#line 72

#line 72
		print_usage ();
#line 72
		exit (0);
#line 72
	 
#line 72
             break;
#line 72
          }
#line 72 "rushopt.opt"
	 case OPTION_VERSION:
#line 72
          {
#line 72

#line 72
		/* Give version */
#line 72
		print_version(program_version, stdout);
#line 72
		exit (0);
#line 72
         
#line 72
             break;
#line 72
          }

#line 77 "rushopt.opt"
        }
#line 77
    }
#line 77
 }   
#line 77

}
