/*
 * THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT. 
 */

#include "stevedore.h"
#include "tallyman_mib.h"

/*
 * Variable handlers.
 * 
 * An instance handler only hands us one request at a time, unwrapping
 * any eventual GETNEXT requests.  
 */


static int
handle_servicesUpTime(netsnmp_mib_handler *handler,
                      netsnmp_handler_registration *reginfo,
                      netsnmp_agent_request_info *reqinfo,
                      netsnmp_request_info *requests)
{
    uint32_t        val = servdb_servicesUpTime();

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_TIMETICKS,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_servicesUpTime\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

static int
handle_servicesTotal(netsnmp_mib_handler *handler,
                     netsnmp_handler_registration *reginfo,
                     netsnmp_agent_request_info *reqinfo,
                     netsnmp_request_info *requests)
{
    uint32_t        val = servdb_servicesTotal();

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_servicesTotal\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

static int
handle_servicesRunning(netsnmp_mib_handler *handler,
                       netsnmp_handler_registration *reginfo,
                       netsnmp_agent_request_info *reqinfo,
                       netsnmp_request_info *requests)
{
    uint32_t        val = servdb_servicesRunning();

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_servicesRunning\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}



void
serviceTable_free(netsnmp_cache * cache, void *vmagic)
{
    netsnmp_tdata  *table = (netsnmp_tdata *) vmagic;
    netsnmp_tdata_row *row;

    while ((row = netsnmp_tdata_row_first(table))) {
        serviceTable_entry_free(row->data);
        SNMP_FREE(row->data);
        netsnmp_tdata_remove_and_delete_row(table, row);
    }
}

/** handles requests for the serviceTable table */
static int
handle_table_serviceTable(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *reqinfo,
                          netsnmp_request_info *requests)
{
    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    struct serviceTable_entry *table_entry;

    switch (reqinfo->mode) {
    case MODE_GET:
        for (request = requests; request; request = request->next) {
            table_entry = (struct serviceTable_entry *)
                netsnmp_tdata_extract_entry(request);
            table_info = netsnmp_extract_table_info(request);

            switch (table_info->colnum) {
            case COLUMN_SERVICENAME:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->serviceName,
                                         table_entry->serviceName_len);
                break;
            case COLUMN_SERVICEINSTANCES:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->serviceInstances);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;
    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR,
                 "unknown mode (%d) in handle_table_serviceTable\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;

    }
    return SNMP_ERR_NOERROR;
}

/** Initialize the serviceTable table by defining its contents and how it's structured */
static void
initialize_table_serviceTable(void)
{
    const oid       serviceTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 103, 1, 4 };
    const size_t    serviceTable_oid_len = OID_LENGTH(serviceTable_oid);
    netsnmp_handler_registration *reg;
    netsnmp_tdata  *table_data;
    netsnmp_table_registration_info *table_info;
    netsnmp_cache  *cache;

    DEBUGMSGTL(("tallyman_mib", "initializing table serviceTable\n"));

    reg =
        netsnmp_create_handler_registration("serviceTable",
                                            handle_table_serviceTable,
                                            serviceTable_oid,
                                            serviceTable_oid_len,
                                            HANDLER_CAN_RONLY);

    table_data = netsnmp_tdata_create_table("serviceTable", 0);
    if (!table_data) {
        snmp_log(LOG_ERR, "error creating tdata table for serviceTable\n");
        return;
    }
    cache = netsnmp_cache_create(-1,
                                 serviceTable_load, serviceTable_free,
                                 serviceTable_oid, serviceTable_oid_len);
    if (!cache) {
        snmp_log(LOG_ERR, "error creating cache for serviceTable\n");
        abort();
    }
    cache->flags |=
        (NETSNMP_CACHE_DONT_AUTO_RELEASE | NETSNMP_CACHE_DONT_FREE_EXPIRED
         | NETSNMP_CACHE_DONT_FREE_BEFORE_LOAD |
         NETSNMP_CACHE_AUTO_RELOAD);

    cache->magic = (void *) table_data;
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    if (!table_info) {
        snmp_log(LOG_ERR, "error creating table info for serviceTable\n");
        return;
    }
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: serviceIndex */
                                     0);

    table_info->min_column = COLUMN_SERVICENAME;
    table_info->max_column = COLUMN_SERVICEINSTANCES;

    netsnmp_tdata_register(reg, table_data, table_info);
    if (cache)
        netsnmp_inject_handler(reg, netsnmp_cache_handler_get(cache));
    /*
     * netsnmp_inject_handler_before(reg, netsnmp_cache_handler_get(cache),
     * TABLE_TDATA_NAME);
     */
}



void
instanceTable_free(netsnmp_cache * cache, void *vmagic)
{
    netsnmp_tdata  *table = (netsnmp_tdata *) vmagic;
    netsnmp_tdata_row *row;

    while ((row = netsnmp_tdata_row_first(table))) {
        instanceTable_entry_free(row->data);
        SNMP_FREE(row->data);
        netsnmp_tdata_remove_and_delete_row(table, row);
    }
}

/** handles requests for the instanceTable table */
static int
handle_table_instanceTable(netsnmp_mib_handler *handler,
                           netsnmp_handler_registration *reginfo,
                           netsnmp_agent_request_info *reqinfo,
                           netsnmp_request_info *requests)
{
    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    struct instanceTable_entry *table_entry;

    switch (reqinfo->mode) {
    case MODE_GET:
        for (request = requests; request; request = request->next) {
            table_entry = (struct instanceTable_entry *)
                netsnmp_tdata_extract_entry(request);
            table_info = netsnmp_extract_table_info(request);

            switch (table_info->colnum) {
            case COLUMN_INSTANCENAME:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->instanceName,
                                         table_entry->instanceName_len);
                break;
            case COLUMN_INSTANCEID:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->instanceID,
                                         table_entry->instanceID_len);
                break;
            case COLUMN_INSTANCESERVICE:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->instanceService,
                                         table_entry->instanceService_len);
                break;
            case COLUMN_INSTANCESTATE:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->instanceState);
                break;
            case COLUMN_INSTANCETIMESTAMP:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->instanceTimeStamp,
                                         table_entry->
                                         instanceTimeStamp_len);
                break;
            case COLUMN_INSTANCEERRORMESSAGE:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->instanceErrorMessage,
                                         table_entry->
                                         instanceErrorMessage_len);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;
    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR,
                 "unknown mode (%d) in handle_table_instanceTable\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;

    }
    return SNMP_ERR_NOERROR;
}

/** Initialize the instanceTable table by defining its contents and how it's structured */
static void
initialize_table_instanceTable(void)
{
    const oid       instanceTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 103, 1, 5 };
    const size_t    instanceTable_oid_len = OID_LENGTH(instanceTable_oid);
    netsnmp_handler_registration *reg;
    netsnmp_tdata  *table_data;
    netsnmp_table_registration_info *table_info;
    netsnmp_cache  *cache;

    DEBUGMSGTL(("tallyman_mib", "initializing table instanceTable\n"));

    reg =
        netsnmp_create_handler_registration("instanceTable",
                                            handle_table_instanceTable,
                                            instanceTable_oid,
                                            instanceTable_oid_len,
                                            HANDLER_CAN_RONLY);

    table_data = netsnmp_tdata_create_table("instanceTable", 0);
    if (!table_data) {
        snmp_log(LOG_ERR,
                 "error creating tdata table for instanceTable\n");
        return;
    }
    cache = netsnmp_cache_create(-1,
                                 instanceTable_load, instanceTable_free,
                                 instanceTable_oid, instanceTable_oid_len);
    if (!cache) {
        snmp_log(LOG_ERR, "error creating cache for instanceTable\n");
        abort();
    }
    cache->flags |=
        (NETSNMP_CACHE_DONT_AUTO_RELEASE | NETSNMP_CACHE_DONT_FREE_EXPIRED
         | NETSNMP_CACHE_DONT_FREE_BEFORE_LOAD |
         NETSNMP_CACHE_AUTO_RELOAD);

    cache->magic = (void *) table_data;
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    if (!table_info) {
        snmp_log(LOG_ERR, "error creating table info for instanceTable\n");
        return;
    }
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: instanceIndex */
                                     0);

    table_info->min_column = COLUMN_INSTANCENAME;
    table_info->max_column = COLUMN_INSTANCEERRORMESSAGE;

    netsnmp_tdata_register(reg, table_data, table_info);
    if (cache)
        netsnmp_inject_handler(reg, netsnmp_cache_handler_get(cache));
    /*
     * netsnmp_inject_handler_before(reg, netsnmp_cache_handler_get(cache),
     * TABLE_TDATA_NAME);
     */
}


/** Initializes the tallyman_mib.c module */
void
init_tallyman_mib(void)
{

    const oid       servicesUpTime_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 103, 1, 1 };


    const oid       servicesTotal_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 103, 1, 2 };


    const oid       servicesRunning_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 103, 1, 3 };


    DEBUGMSGTL(("tallyman_mib", "Initializing\n"));

    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("servicesUpTime", handle_servicesUpTime,
                             servicesUpTime_oid,
                             OID_LENGTH(servicesUpTime_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("servicesTotal", handle_servicesTotal,
                             servicesTotal_oid,
                             OID_LENGTH(servicesTotal_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("servicesRunning", handle_servicesRunning,
                             servicesRunning_oid,
                             OID_LENGTH(servicesRunning_oid),
                             HANDLER_CAN_RONLY));

    initialize_table_serviceTable();
    initialize_table_instanceTable();
}

void
deinit_tallyman_mib(void)
{
    /*
     * Nothing 
     */
}

/*
 * Local variables:
 * buffer-read-only: t
 * End:
 * vi: set ro:
 */
